/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.commands.CPY;
import emulator.unittest.hardware.nmos6502.MockOperand;
import org.junit.Assert;
import org.junit.Test;

public class CPYTest {
    @Test
    public void testExecute() throws EmulatorException {
        this.checkCMP(0, 0);
        this.checkCMP(0, 62);
        this.checkCMP(63, 62);
        this.checkCMP(63, 63);
        this.checkCMP(63, 64);
        this.checkCMP(63, 255);
        this.checkCMP(255, 0);
    }

    private void checkCMP(int number, int operand) throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        cpu.setY(new HwByte((long)number));
        CPY cmp = new CPY();
        cmp.execute(cpu, new MockOperand(operand));
        Assert.assertEquals((long)number, (long)cpu.getY().getNumber());
        Assert.assertEquals((Object)(number == operand ? 1 : 0), (Object)cpu.getFlags().getZero());
        Assert.assertEquals((Object)(number >= operand ? 1 : 0), (Object)cpu.getFlags().getCarry());
        Assert.assertEquals((Object)((number - operand & 0x80) != 0 ? 1 : 0), (Object)cpu.getFlags().getNegative());
    }
}

